

<?php $__env->startSection('title', 'Edit User'); ?>

<?php $__env->startSection('content'); ?>
<div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
    <h1 class="text-3xl font-bold text-gray-800 mb-6">Edit User</h1>

    <form method="POST" action="<?php echo e(route('admin.users.update', $user->id)); ?>" class="bg-white rounded-lg shadow p-6">
        <?php echo csrf_field(); ?>
        <?php echo method_field('PUT'); ?>

        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
            <div>
                <label class="block text-gray-700 text-sm font-bold mb-2">Name *</label>
                <input type="text" name="name" value="<?php echo e(old('name', $user->name)); ?>" required class="w-full px-3 py-2 border rounded">
            </div>

            <div>
                <label class="block text-gray-700 text-sm font-bold mb-2">Email *</label>
                <input type="email" name="email" value="<?php echo e(old('email', $user->email)); ?>" required class="w-full px-3 py-2 border rounded">
            </div>

            <div>
                <label class="block text-gray-700 text-sm font-bold mb-2">Password (leave blank to keep current)</label>
                <input type="password" name="password" class="w-full px-3 py-2 border rounded">
            </div>

            <div>
                <label class="block text-gray-700 text-sm font-bold mb-2">Role *</label>
                <select name="role" required class="w-full px-3 py-2 border rounded">
                    <option value="admin" <?php echo e($user->role === 'admin' ? 'selected' : ''); ?>>Admin</option>
                    <option value="doctor" <?php echo e($user->role === 'doctor' ? 'selected' : ''); ?>>Doctor</option>
                    <option value="pharmacist" <?php echo e($user->role === 'pharmacist' ? 'selected' : ''); ?>>Pharmacist</option>
                    <option value="patient" <?php echo e($user->role === 'patient' ? 'selected' : ''); ?>>Patient</option>
                </select>
            </div>

            <div>
                <label class="block text-gray-700 text-sm font-bold mb-2">Status</label>
                <select name="is_active" class="w-full px-3 py-2 border rounded">
                    <option value="1" <?php echo e($user->is_active ? 'selected' : ''); ?>>Active</option>
                    <option value="0" <?php echo e(!$user->is_active ? 'selected' : ''); ?>>Inactive</option>
                </select>
            </div>
        </div>

        <div class="mt-6 flex justify-end space-x-4">
            <a href="<?php echo e(route('admin.users')); ?>" class="bg-gray-300 hover:bg-gray-400 text-gray-800 px-6 py-2 rounded">
                Cancel
            </a>
            <button type="submit" class="bg-blue-600 hover:bg-blue-700 text-white px-6 py-2 rounded">
                Update User
            </button>
        </div>
    </form>
</div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\BrainTech\Documents\BEAUTEZ SYSTEM\resources\views/admin/edit-user.blade.php ENDPATH**/ ?>